/*
 * Decompiled with CFR 0.152.
 */
package ags.script.commands;

import ags.script.AbstractCommand;
import ags.script.Engine;
import ags.script.InitalizationException;
import ags.script.Target;
import ags.script.exception.FatalScriptException;

public class Require
extends AbstractCommand {
    private String targetName;

    protected void init(String[] args) throws InitalizationException {
        if (args.length != 2) {
            throw new InitalizationException("Require called with wrong number of arguments!");
        }
        this.targetName = args[1];
    }

    public void checkPaths() {
    }

    protected void doExecute() throws FatalScriptException {
        Target t = Target.getTarget(this.targetName);
        if (t == null) {
            Engine.getOut().println("Error in line " + this.getLineNumber() + ", target '" + this.targetName + "' not found: ");
            throw new FatalScriptException("Target not found: " + this.targetName, null);
        }
        try {
            t.require();
        }
        catch (FatalScriptException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new FatalScriptException("Unhandled error when executing target " + t.getName(), ex);
        }
    }
}

